<?php
function cpt_menu(){
	global $options;
        
        
         if ( $options ) {
  $url_rewrite = $options['theme_menu_item_url'];
  if( !$url_rewrite ) { $url_rewrite = 'menu'; }
 } else {
  $url_rewrite = 'menu';
 }

	register_post_type('post_menu',
		array(
			'labels' => array(
				'name' => 'Menu',
				'singular_name' => 'Menu Item',
				'add_new' => 'Add New Menu Item',
				'add_new_item' => 'Add New Menu Item',
				'edit' => 'Edit',
				'edit_item' => 'Edit Menu Item',
				'new_item' => 'New Menu Item',
				'view' => 'View',
				'view_item' => 'View Menu Item',
				'search_items' => 'Search Menu Items',
				'not_found' => 'No Menu items found',
				'not_found_in_trash' => 'No Menu items found in Trash',
				'parent' => 'Parent Menu Item'
			),
			'description' => 'Easily lets you create some beautiful menu items.',
			'public' => true,
			'show_ui' => true, 
			'_builtin' => false,
			'capability_type' => 'page',
			'hierarchical' => true,
			'rewrite' => array('slug' => $url_rewrite),
			'supports' => array('title', 'editor', 'thumbnail', 'comments'),
		)
	); 
	flush_rewrite_rules();
}

function tax_menu() {
	global $options;
        
       if ( $options ) {  
		$url_rewrite = $options['theme_menu_item_type_url'];
		if( !$url_rewrite ) { $url_rewrite = 'menu-category'; }
	} else {
		$url_rewrite = 'menu-category';
	}

	register_taxonomy('menu_item_types', 'post_menu', 
         
		array( 
			'hierarchical' => true, 
			'labels' => array(
				  'name' => 'Menu Category',
				  'singular_name' => 'Menu Categories',
				  'search_items' =>  'Search Categories',
				  'popular_items' => 'Popular Categories',
				  'all_items' => 'All Categories',
				  'parent_item' => 'Parent Categories',
				  'parent_item_colon' => 'Parent Category:',
				  'edit_item' => 'Edit Category',
				  'update_item' => 'Update Category',
				  'add_new_item' => 'Add New Category',
				  'new_item_name' => 'New Category Name'
			),
			'show_ui' => true,
			'query_var' => true, 
			'rewrite' => array('slug' => $url_rewrite)
		) 
	); 
	flush_rewrite_rules();	
}

add_action('init', 'cpt_menu');
add_action('init', 'tax_menu');