<?php
/*
 * Plugin Name: DD Menu Widget
 * Plugin URI: http://themeforest.net/user/DDStudios/portfolio
 * Description: A widget that displays recent menu items
 * Version: 1.0
 * Author: Dany Duchaine
 * Author URI: http://themeforest.net/user/DDStudios/
 */

/*
 * Add function to widgets_init that'll load our widget.
 */
add_action( 'widgets_init', 'dd_menu_widgets' );

/*
 * Register widget.
 */
function dd_menu_widgets() {
	register_widget( 'DD_Menu_Widget' );
}

/*
 * Widget class.
 */
class dd_menu_widget extends WP_Widget {

	/* ---------------------------- */
	/* -------- Widget setup -------- */
	/* ---------------------------- */
	
	function DD_Menu_Widget() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'dd_menu_widget', 'description' => __('A widget that displays your latest menu items.', 'localization') );

		 /* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'dd_menu_widget' );

		/* Create the widget. */
		$this->WP_Widget( 'dd_menu_widget', __('DD Menu Widget','localization'), $widget_ops, $control_ops );
	}

	/* ---------------------------- */
	/* ------- Display Widget -------- */
	/* ---------------------------- */
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
                $title = apply_filters('widget_title', $instance['title'] );
	
		$postcount = $instance['postcount'];
                $categories = $instance['categories'];
                $viewall = $instance['viewall'];
	
		/* Before widget (defined by themes). */
 
              
                
         
                
		
              	/* Before widget (defined by themes). */
        echo $before_widget;
                
         
             
        	
        ?>

  <h3>
      
      <?php echo $title ?>
      
      
     
      
  
  </h3>
                    
                                               <ul class="dd_post_items menuWidget">
                    
                                          <?php if (($categories  == '0') || ($categories  === '')) { ?>
                                                   
                       <?php
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$arguments = array(
    'post_type' => 'post_menu',
    'post_status' => 'publish',
    'paged' => $paged,
    'showposts' => $postcount
);


$menu_query = new WP_Query($arguments);

dd_set_query($menu_query);

?>
                                                   
                                                               <?php } else { ?>
                                                               <?php
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;



          $arguments = array(
                        'posts_per_page' => $postcount,
               'post_status' => 'publish',
    'paged' => $paged,
                        'tax_query' => array(
                                array(
                                        'taxonomy' => 'menu_item_types',
                                        'field' => 'id',
                                        'terms' => $categories
                                )
                        )
                );
          
$menu_query = new WP_Query($arguments);

dd_set_query($menu_query);

?>               
                                                               <?php } ?>        
                                                   
                       <?php if ($menu_query->have_posts()) : while ($menu_query->have_posts()) : $menu_query->the_post(); ?>
                      
                      
                            
                
                            
                        <li <?php post_class('dd_post'); ?>>
                            
                            
                            <?php 

$menuimg = get_post_meta(get_the_ID(), 'menuimg', true);
$menuprice = get_post_meta(get_the_ID(), 'menuprice', true);
$menupricesmall = get_post_meta(get_the_ID(), 'menupricesmall', true);
$menutag = get_post_meta(get_the_ID(), 'menutag', true);
$menucurrency = get_post_meta(get_the_ID(), 'menucurrency', true);


?>
                        
                                    
                            <div class="dd_post_wrapper clearfix">
                                
                                 
                                    <?php if( $menuimg) { ?>
                                
                             <div class="dd_post_thumb">
                              
                               <a href="<?php the_permalink(); ?>"><img src="<?php echo $menuimg; ?>" alt="" /></a>
                              
                          </div>
                                
                                        <?php } ?>
                            
                            <div class="dd_post_meta">
                                
                                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                
                                
                               <?php if( $menutag) { ?>  <span class="tag"><?php echo $menutag; ?></span><?php } ?>
                                 <?php if( $menuprice) { ?><span class="price"><span class="dollar"><?php echo $menucurrency; ?></span><?php echo $menuprice; ?> <?php if( $menupricesmall) { ?><span class="pricesmall"><?php echo $menupricesmall; ?></span><?php } ?></span><?php } ?>
                                
                            </div>
                                
                            </div>

                        
                              </li>
                              
              
           
      <?php endwhile; ?>
                    
                

<?php endif; ?>
                     
                 </ul>

               
           <?php if ($viewall != '') { ?>
                    

                  <span>  <a class="viewall continue button-small-theme" href="<?php echo $viewall ?>"><?php _e('VIEW ALL', 'localization'); ?></a></span>
                  
            
                                <?php } ?>
      
		<?php 

		/* After widget (defined by themes). */
                
		
        echo $after_widget;
                
         
		
	}

	/* ---------------------------- */
	/* ------- Update Widget -------- */
	/* ---------------------------- */
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
                $instance['title'] = strip_tags( $new_instance['title'] );
	
		$instance['postcount'] = strip_tags( $new_instance['postcount'] );
                $instance['categories'] = strip_tags( $new_instance['categories'] );
                $instance['viewall'] = strip_tags( $new_instance['viewall'] );
		

		/* No need to strip tags for.. */

		return $instance;
	}
	
	/* ---------------------------- */
	/* ------- Widget Settings ------- */
	/* ---------------------------- */
	
	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
                'title' => 'OUR MENU',
                'show_option_all' => 'All',
		'postcount' => '5',
				);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

	<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'localization') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>

            
		<!-- Postcount: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'postcount' ); ?>"><?php _e('Number of posts', 'localization') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'postcount' ); ?>" name="<?php echo $this->get_field_name( 'postcount' ); ?>" value="<?php echo $instance['postcount']; ?>" />
		</p>
                
                <p>
			<label for="<?php echo $this->get_field_id('categories'); ?>">
					<?php _e('Category:', 'ototw'); ?>
					<br />
			</label>
			
			<?php wp_dropdown_categories( 
				array( 
					'name' => $this->get_field_name("categories"), 
					'selected' => $instance["categories"], 
					'taxonomy'  => 'menu_item_types',
                                        'show_option_all' => 'All',
                                    	'hide_if_empty' => 1
				) 
			); ?>
			
		</p>
                
                <!-- Postcount: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'viewall' ); ?>"><?php _e('"View All" button URL', 'localization') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'viewall' ); ?>" name="<?php echo $this->get_field_name( 'viewall' ); ?>" value="<?php echo $instance['viewall']; ?>" />
		</p>
		
		<!-- Tweettext: Text Input -->
				
	<?php
	}
}
?>