<!DOCTYPE html>
<!--[if lt IE 7 ]><html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!--><html <?php language_attributes(); ?>> <!--<![endif]-->
<head>

	<!-- Basic Page Needs
  ================================================== -->
	<meta charset="utf-8">
	<title>
		   <?php
		      if (function_exists('is_tag') && is_tag()) {
		         single_tag_title("Tag Archive for &quot;"); echo '&quot; - '; }
                         elseif ( is_front_page()) {
		         wp_title(''); echo ' Home - '; }
                         
                        
		      elseif (is_archive()) {
		         wp_title(''); echo ' Archive - '; }
		      elseif (is_search()) {
		         echo 'Search for &quot;'.esc_html($s).'&quot; - '; }
		      elseif (!(is_404()) && (is_single()) || (is_page())) {
		         wp_title(''); echo ' - '; }
		      elseif (is_404()) {
		         echo 'Not Found - '; }
		      if (is_home()) {
		         bloginfo('name'); echo ' - '; bloginfo('description'); }
		      else {
		          bloginfo('name'); }
		      if ($paged>1) {
		         echo ' - page '. $paged; }
		   ?>
	</title>
 
        <meta name="author" content="">


	<!-- Mobile Specific Metas
  ================================================== -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
          <?php if (is_search()) { ?>
	   <meta name="robots" content="noindex, nofollow" /> 
	<?php } ?>
            

	<!--[if lt IE 9]>
		<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<!-- Favicons
	================================================== -->
	<link rel="shortcut icon" href="images/favicon.ico">
	<link rel="apple-touch-icon" href="images/apple-touch-icon.png">
	<link rel="apple-touch-icon" sizes="72x72" href="images/apple-touch-icon-72x72.png">
	<link rel="apple-touch-icon" sizes="114x114" href="images/apple-touch-icon-114x114.png">
        
        <!-- Atoms & Pingback
        ================================================== -->

        <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
        <link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
        <link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

        <!-- Theme Hook -->
        
     <?php wp_head(); ?>
     

</head>

    <body data-spy="scroll" data-target=".subnav" data-offset="50" <?php body_class(); ?>>

        
        
           
          <ul class="socialNav">
                    
                        <?php if (ot_get_option('donatelink') != '') { ?>
                        
                        <li class="donate"><a href="<?php echo ot_get_option('donatelink') ?>"><i class="icon-plus-circled"></i><?php echo ot_get_option('donatebtntext') ?></a></li>
                        
                            <?php } ?>
                        
                         <?php if (ot_get_option('contactlink') != '') { ?>
                        <li class="mail"><a href="<?php echo ot_get_option('contactlink') ?>"><i class="icon-mail"></i></a></li>
                              <?php } ?>
                        
                        <?php if (ot_get_option('twitterlink') != '') { ?>
                        <li class="twitter"><a href="<?php echo ot_get_option('twitterlink') ?>"><i class="icon-twitter"></i></a></li>
                              <?php } ?>
                         <?php if (ot_get_option('facebooklink') != '') { ?>
                        <li class="facebook"><a href="<?php echo ot_get_option('facebooklink') ?>"><i class="icon-facebook"></i></a></li>
                              <?php } ?>
                        
                         
                        
                         <?php if (ot_get_option('vimeolink') != '') { ?>
                        <li class="vimeo"><a href="<?php echo ot_get_option('vimeolink') ?>"><i class="icon-vimeo"></i></a></li>
                              <?php } ?>
                        
                         <?php if (ot_get_option('googlelink') != '') { ?>
                        <li class="google"><a href="<?php echo ot_get_option('googlelink') ?>"><i class="icon-gplus"></i></a></li>
                              <?php } ?>
                        
                   
                        
                         <?php if (ot_get_option('flickrlink') != '') { ?>
                        <li class="flickr"><a href="<?php echo ot_get_option('flickrlink') ?>"><i class="icon-flickr"></i></a></li>
                              <?php } ?>
                        
                  
                        
                              <?php if (ot_get_option('pinterestlink') != '') { ?>
                        <li class="pinterest"><a href="<?php echo ot_get_option('pinterestlink') ?>"><i class="icon-pinterest"></i></a></li>
                              <?php } ?>
                               <?php if (ot_get_option('linkedinlink') != '') { ?>
                        <li class="linkedin"><a href="<?php echo ot_get_option('linkedinlink') ?>"><i class="icon-linkedin"></i></a></li>
                              <?php } ?>
                          <?php if (ot_get_option('dribbblelink') != '') { ?>
                        <li class="dribbble"><a href="<?php echo ot_get_option('dribbblelink') ?>"><i class="icon-dribbble"></i></a></li>
                              <?php } ?>
                        
                        <?php if (ot_get_option('instagramlink') != '') { ?>
                        <li class="instagram"><a href="<?php echo ot_get_option('instagramlink') ?>"><i class="icon-instagrem"></i></a></li>
                              <?php } ?>
                        
                         <?php if (ot_get_option('behancelink') != '') { ?>
                        <li class="behance"><a href="<?php echo ot_get_option('behancelink') ?>"><i class="icon-behance"></i></a></li>
                              <?php } ?>
                        
                        
                         <?php if (ot_get_option('topbarsearch') == 'yes') { ?>
                        <li class="searchForm"><a href="#"><i class="icon-search"></i><i class="icon-cancel"></i></a></li>
                              <?php } ?>
                        
                           <?php if (ot_get_option('topbarsearch') == 'yes') { ?>
                
                  <li class="topBarSearch clearfix">
                    
                      <?php get_search_form(); ?>
                    
                </li>

                    <?php } ?>
                        
                </ul>
        
        
             <?php if (ot_get_option('fullbg') === 'yes') { ?>
  
      <script type="text/javascript">
                       
                       
                       jQuery(window).load(function() {
 
  jQuery.backstretch("<?php echo ot_get_option('backgroundimg') ?>");
 

 
});
                       
                             
      
         
           
           </script>
           
               <?php } ?>
           
        <header>
            
            <div class="container headerWrapper">
                
                <div class="shadowWrapper sixteen columns">
                    
                     <div class="five columns alpha logoWrapper">
                    
                      <a href="<?php echo home_url(); ?>"><img alt="" src="<?php echo ot_get_option('logo') ?>" /></a>
                    
                </div>
                
                <div class="eleven columns omega navWrapper">
                    
                     <nav class="mainNav">

                    <?php
                    wp_nav_menu(array(
                        'container' => false,
                        'menu_class' => 'nav clearfix sf-menu sf-js-enabled sf-shadow',
                        'theme_location' => 'main_menu',
                        'echo' => true,
                        'before' => '',
                        'after' => '',
                        'link_before' => '',
                        'fallback_cb' => 'display_home2',
                        'link_after' => '',
                        'depth' => 0
                        )
                    );
                    ?>
                 
               

                </nav>
            
            <nav class="secondaryNav">
                
                
                    <div class="container mobileNav">
                        
                    <div class="sixteen columns mobileNavWrapper"></div>
                    
                </div>

            </nav>
                    
                </div>
                
                <div class="eleven columns">
                    
                    <ul class="headerInfo clearfix">
                        
                          <?php if ((ot_get_option('headertitle1')) || (ot_get_option('headertext1')) != '') { ?>
                        
                        <li>
                            
                               <?php if (ot_get_option('headertitle1') != '') { ?><h3><?php echo ot_get_option('headertitle1') ?></h3><?php } ?>
                    
                               <?php if (ot_get_option('headertext1') != '') { ?><span><?php echo ot_get_option('headertext1') ?></span><?php } ?>
                            
                        </li>
                        
                            <?php } ?>
                        
                       <?php if ((ot_get_option('headertitle2')) || (ot_get_option('headertext2')) != '') { ?>
                        
                        <li>
                            
                               <?php if (ot_get_option('headertitle2') != '') { ?><h3><?php echo ot_get_option('headertitle2') ?></h3><?php } ?>
                    
                               <?php if (ot_get_option('headertext2') != '') { ?><span><?php echo ot_get_option('headertext2') ?></span><?php } ?>
                            
                        </li>
                        
                            <?php } ?>
                        
                          <?php if ((ot_get_option('headertitle3')) || (ot_get_option('headertext3')) != '') { ?>
                        
                        <li>
                            
                               <?php if (ot_get_option('headertitle3') != '') { ?><h3><?php echo ot_get_option('headertitle3') ?></h3><?php } ?>
                    
                               <?php if (ot_get_option('headertext3') != '') { ?><span><?php echo ot_get_option('headertext3') ?></span><?php } ?>
                            
                        </li>
                        
                            <?php } ?>
                                              
                    </ul>
                    
                </div>
                    
                </div>
                
            </div>
            
               

           
            
        </header>
     
            
        <?php 

   $headerimg = get_post_meta(get_the_ID(), 'headerimg', true);

?>
        
         <?php 
                            
                          $image_url = apply_filters( 'taxonomy-images-queried-term-image-url', '', array(
    'image_size' => 'full'
    ) );
                            
                            ?>  
        

     
                            
        
                    <?php  if ($image_url  !== '') { ?>
                       

         <div class="container">

            <div class="fifteen columns pageBanner offset-by-one" style="background: url(<?php echo $image_url; ?>) top center no-repeat;">
                
        
                 
                 <?php if ( term_description() !== '' ) { ?>



<h1><?php echo term_description(); ?></h1>



<?php } ?>

                
            </div>
            
        </div>

        
                                   <?php }  else if( $headerimg) { ?>
    
        <div class="container bannerWrapper">

            <div class="fifteen columns pageBanner archiveBanner offset-by-one" style="background: url(<?php echo $headerimg; ?>) top center no-repeat;">
                
                 <h1><?php the_title(); ?></h1>
                
            </div>
            
        </div>

                            
        
                    <?php }  ?>